<?php
add_action( 'admin_init',  'initialize_sendy_translation_options' );
function initialize_sendy_translation_options() {

	if ( false == get_option( 'sendy_translation_settings' ) ) {
		$default_args=array(
			'name'=>__( 'Name', 'sendywidget' ),
			'email'=>__( 'Email', 'sendywidget' ),
			'email_error'=>__( 'Please enter a valid email address', 'sendywidget' ),
			'captcha_error'=>__( 'The security code entered was incorrect', 'sendywidget' ),
			'already_subscribed'=>__( 'That address is already in use', 'sendywidget' ),
			'success_message' => __( 'Thanks for signing up', 'sendywidget' ),
			'sigup_text'=>__( 'Signup for newsletter', 'sendywidget' ),
			'recaptcha_label'=>__( 'Google reCAPTCHA', 'sendywidget' ),
			'woo_checkout_message'=>__( "Yes I\'d like to recieve email updates and special offers!", 'sendywidget' ),
			'terms_text'=>__( 'I agree to terms & conditions', 'sendywidget' ),
			'subscriber_counter'=>__( 'subscribers', 'sendywidget' ),
			'subscribe_button'=>__( 'Subscribe', 'sendywidget' )
		);

		add_option( 'sendy_translation_settings' , $default_args );
	}


	// Translation Settings
	add_settings_section(
		'translation_settings_section',
		'Translation',
		'',
		'sendy-widget-pro-settings'
	);

	add_settings_field(
		'form_name_field',
		'Name Field',
		'sendy_translation_name_callback',
		'sendy-widget-pro-settings',
		'translation_settings_section',
		array( '' )
	);

	add_settings_field(
		'form_email_field',
		'Email Field',
		'sendy_translation_email_callback',
		'sendy-widget-pro-settings',
		'translation_settings_section',
		array( '' )
	);
	add_settings_field(
		'form_email_error_field',
		'Email validation error',
		'sendy_translation_email_error_callback',
		'sendy-widget-pro-settings',
		'translation_settings_section',
		array( '' )
	);

	add_settings_field(
		'form_already_subs_field',
		'Already Subscribed Error',
		'sendy_translation_subscribed_error_callback',
		'sendy-widget-pro-settings',
		'translation_settings_section',
		array( '' )
	);



	add_settings_field(
		'form_success_field',
		'Success Message',
		'sendy_translation_success_callback',
		'sendy-widget-pro-settings',
		'translation_settings_section',
		array( '' )
	);
	add_settings_field(
		'form_recaptcha_label',
		'reCAPTCHA label',
		'sendy_recaptcha_label_callback',
		'sendy-widget-pro-settings',
		'translation_settings_section',
		array( '' )
	);
	add_settings_field(
		'form_terms_field',
		'Terms & Conditions text',
		'sendy_translation_terms_callback',
		'sendy-widget-pro-settings',
		'translation_settings_section',
		array( '' )
	);
	add_settings_field(
		'form_subscriber_counter_field',
		'Subscriber Counter text',
		'sendy_translation_subscriber_counter_callback',
		'sendy-widget-pro-settings',
		'translation_settings_section',
		array( '' )
	);

	add_settings_field(
		'form_subscribe_button_field',
		'Subscribe Button',
		'sendy_translation_button_callback',
		'sendy-widget-pro-settings',
		'translation_settings_section',
		array( '' )
	);

	add_settings_field(
		'form_captcha_field',
		'Captcha validation error',
		'sendy_translation_captcha_callback',
		'sendy-widget-pro-settings',
		'translation_settings_section',
		array( '' )
	);
	add_settings_field(
		'form_signup_field',
		'Register page text',
		'sendy_translation_signup_callback',
		'sendy-widget-pro-settings',
		'translation_settings_section',
		array( '' )
	);
	add_settings_field(
		'form_woo_checkout_field',
		'Checkout page text',
		'sendy_translation_woo_checkout_callback',
		'sendy-widget-pro-settings',
		'translation_settings_section',
		array( '' )
	);

	register_setting( 'sendy_translation_settings', 'sendy_translation_settings' );
}


function sendy_translation_name_callback() {

	$translation_settings = get_option( "sendy_translation_settings" );

	$html='<div><input type="text"  value="'.$translation_settings["name"].'" class="regular-text"  name="sendy_translation_settings[name]" >  </div>';
	$html.='<p class="description">This setting can be overidden for each Form from translation settings on edit Form page.</p>';

	echo $html;

}

function sendy_translation_email_callback() {

	$translation_settings = get_option( "sendy_translation_settings" );

	$html='<div><input type="text"  value="'.$translation_settings["email"].'" class="regular-text"  name="sendy_translation_settings[email]" >  </div>';
	$html.='<p class="description">This setting can be overidden for each Form from translation settings on edit Form page.</p>';

	echo $html;

}

function sendy_translation_email_error_callback() {

	$translation_settings = get_option( "sendy_translation_settings" );

	$html='<div><input type="text"  value="'.$translation_settings["email_error"].'" class="large-text"  name="sendy_translation_settings[email_error]" >  </div>';
	$html.='<p class="description">This setting can be overidden for each Form from translation settings on edit Form page.</p>';
	echo $html;

}


function sendy_translation_captcha_callback() {

	$translation_settings = get_option( "sendy_translation_settings" );

	$html='<div><input type="text"  value="'.$translation_settings["captcha_error"].'" class="large-text"  name="sendy_translation_settings[captcha_error]" >  </div>';

	echo $html;

}


function sendy_translation_subscribed_error_callback() {

	$translation_settings = get_option( "sendy_translation_settings" );

	$html='<div><input type="text"  value="'.$translation_settings["already_subscribed"].'" class="large-text"  name="sendy_translation_settings[already_subscribed]" >  </div>';
	$html.='<p class="description">This setting can be overidden for each Form from translation settings on edit Form page.</p>';
	echo $html;

}
function sendy_translation_signup_callback() {

	$translation_settings = get_option( "sendy_translation_settings" );

	$html='<div><input type="text"  value="'.$translation_settings["sigup_text"].'" class="large-text"  name="sendy_translation_settings[sigup_text]" >  </div>';

	echo $html;

}
function sendy_translation_woo_checkout_callback() {

	$translation_settings = get_option( "sendy_translation_settings" );

	$html='<div><input type="text"  value="'.stripslashes( $translation_settings["woo_checkout_message"] ).'" class="large-text"  name="sendy_translation_settings[woo_checkout_message]" >  </div>';

	echo $html;

}


function sendy_translation_success_callback() {

	$translation_settings = get_option( "sendy_translation_settings" );

	$html='<div><input type="text"  value="'.$translation_settings["success_message"].'" class="large-text"  name="sendy_translation_settings[success_message]" >  </div>';
	$html.='<p class="description">This setting can be overidden for each Form from translation settings on edit Form page.</p>';
	echo $html;

}

function sendy_recaptcha_label_callback() {

	$translation_settings = get_option( "sendy_translation_settings" );

	$html='<div><input type="text"  value="'.$translation_settings["recaptcha_label"].'" class="large-text"  name="sendy_translation_settings[recaptcha_label]" >  </div>';
	$html.='<p class="description">This setting can be overidden for each Form from translation settings on edit Form page.</p>';
	echo $html;

}

function sendy_translation_terms_callback() {

	$translation_settings = get_option( "sendy_translation_settings" );

	// temp hack to update default value
	if ( empty( $translation_settings["terms_text"] ) ) {
		$translation_settings["terms_text"]='I agree to terms & conditions';
	}


	$html='<div><input type="text"  value="'.$translation_settings["terms_text"].'" class="large-text"  name="sendy_translation_settings[terms_text]" >  </div>';
	$html.='<p class="description">This setting can be overidden for each Form from translation settings on edit Form page.</p>';
	echo $html;

}
function sendy_translation_subscriber_counter_callback() {

	$translation_settings = get_option( "sendy_translation_settings" );

	// temp hack to update default value
	if ( empty( $translation_settings["subscriber_counter"] ) ) {
		$translation_settings["subscriber_counter"]='subscribers';
	}


	$html='<div><input type="text"  value="'.$translation_settings["subscriber_counter"].'" class="large-text"  name="sendy_translation_settings[subscriber_counter]" >  </div>';
$html.='<p class="description">This setting can be overidden for each Form from translation settings on edit Form page.</p>';
	echo $html;

}

function sendy_translation_button_callback() {

	$translation_settings = get_option( "sendy_translation_settings" );

	// temp hack to update default value
	if ( empty( $translation_settings["subscribe_button"] ) ) {
		$translation_settings["subscribe_button"]='Subscribe';
	}

	$html='<div><input type="text"  value="'.$translation_settings["subscribe_button"].'" class="large-text"  name="sendy_translation_settings[subscribe_button]" >  </div>';
	$html.='<p class="description">This setting can be overidden for each Form from translation settings on edit Form page.</p>';
	echo $html;

}
