<?php

/**
 * When the post is saved, saves our custom data.
 *
 * @param int $post_id The ID of the post being saved.
 */
function swp_save_meta_box_data( $post_id ) {

	/*
	 * We need to verify this came from our screen and with proper authorization,
	 * because the save_post action can be triggered at other times.
	 */

	// Check if our nonce is set.
	if ( ! isset( $_POST['swp_meta_box_nonce'] ) ) {
	//	return;
	}

	// Verify that the nonce is valid.
	//if ( ! wp_verify_nonce( $_POST['swp_meta_box_nonce'], 'swp_save_meta_box_data' ) ) {
	//	return;
	//}

	// If this is an autosave, our form has not been submitted, so we don't want to do anything.
	if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
		return;
	}

	// Check the user's permissions.
	if ( isset( $_POST['post_type'] ) && 'swp_forms' != $_POST['post_type'] ) {

			return;

	}

	/* OK, it's safe for us to save the data now. */

	// Make sure that it is set.
	if ( ! isset( $_POST['styler'] ) ) {
		return;
	}
			//print_r(serialize($_POST['styler'])); die;
	// Sanitize user input.
	//$my_data = sanitize_text_field( $_POST['swp_new_field'] );

	// Update the meta field in the database.
	update_post_meta( $post_id, 'swp_styler_settings', $_POST['styler'] );
}
add_action( 'save_post', 'swp_save_meta_box_data' );