<?php
class SWP_Form_Design_Settings {
	private static $intialized = false;
	private static $style_setting;
	private static $old_translation_settings;

	function __construct() {

		if ( ! self::$intialized ) {
			add_action( 'swp_form_general_settings', array( $this, 'create_form_general_settings' ) );
			add_action( 'swp_form_translation_settings', array( $this, 'create_form_translation_settings' ) );
			add_action( 'swp_form_design_settings', array( $this, 'create_form_design_settings' ) );

			add_action( 'swp_field_design_settings', array( $this, 'create_field_design_settings' ) );
			add_action( 'swp_label_design_settings', array( $this, 'create_label_design_settings' ) );
			add_action( 'swp_submit_design_settings', array( $this, 'create_submit_design_settings' ) );
			add_action( 'swp_admin_error_design', array( $this, 'create_error_design_settings' ) );
		}

		$old_translation_settings = get_option( 'sendy_translation_settings' );
		self::$old_translation_settings = $old_translation_settings;
		self::$intialized = true;


	}

	//Plugin starting point.
	public static function setup() {
		$class = __CLASS__;
		new $class;
	}


	public static function create_form_general_settings( $form_id ) {
		$setting = get_post_meta( $form_id, 'swp_styler_settings', true );
		self::$style_setting = $setting;
?>

	<table class="styler-form-table form-table" >
		<tbody>

			<tr valign ="top">
				<th scope="row">Form Type</th>
				<td>
				<?php  $form_type =  self::get( 'form', 'form_type' ); ?>
				<select name="styler[form_type]" >
					<option  <?php selected( 'subscribe', $form_type, true ) ?> value="subscribe">Subscribe</option>
					<option <?php selected( 'unsubscribe', $form_type, true ) ?> value="unsubscribe">Unsubscribe</option>

					</select>
				</td>
			</tr>

			<tr valign ="top">
				<th scope="row">List <span style="color:red">*</span> </th>
				<td>

				<select multiple  name="styler[list][]" >
					<option value="">Select List</option>

						<?php
							$current_list =  self::get( 'form', 'list' );
							$sendy_lists=get_option( 'sendy_lists' );
							if ( !empty( $sendy_lists ) ) {
								foreach ( $sendy_lists as $list_id => $list_name ) {
									if( is_array($current_list)){ ?>
									<option value="<?php echo $list_id ?>" <?php echo in_array( $list_id, $current_list )? 'selected="selected"':'';  ?>><?php echo $list_name; ?></option>
									<?php }else{
									?>
													<option value="<?php echo $list_id ?>" <?php selected( $current_list, $list_id, true ) ?>><?php echo $list_name; ?></option>
											<?php }
										}
							} ?>
				</select>
					<p class="description">Select the list to which you want to add users in Sendy, you can select multiple lists </p>
				</td>
			</tr>

				<tr valign ="top">
				<th scope="row">Send IP Address</th>
				<td>

				<input type="checkbox" class="" name="styler[ip_address]" value="1" <?php  checked( self::get( 'form', 'ip_address' ), '1', true); ?>>
					<p class="description">Send the IP Address of user </p>
				</td>
			</tr>

				<tr valign ="top">
				<th scope="row">Send Page Referrer</th>
				<td>
				<?php
				//var_dump(self::get( 'form', 'page_referrer' )); die;
				?>
				<input type="checkbox" class="" name="styler[page_referrer]" value="1" <?php  checked( self::get( 'form', 'page_referrer' ), '1', true); ?> >
					<p class="description">Send Page Referrer of user </p>
				</td>
			</tr>

			<tr valign ="top">
				<th scope="row">GDPR</th>
				<td>

				<input type="checkbox" class="" name="styler[gdpr]" value="1" <?php  checked( self::get( 'form', 'gdpr' ), '1', true); ?>>
					<p class="description"> If you're signing up EU users in a GDPR compliant manner, check this checkbox. </p>
				</td>
			</tr>
			<tr valign ="top">
				<th scope="row">Make Name as required field?</th>
				<td>

				<input type="checkbox" class="" name="styler[name_required]" value="1" <?php  checked( self::get( 'form', 'name_required' ), '1', true); ?>>
					<p class="description"> </p>
				</td>
			</tr>

				<tr valign ="top">
				<th scope="row">Redirect Url</th>
				<td>

				<input type="text" class="regular-text" name="styler[redirect_url]" value="<?php echo self::get( 'form', 'redirect_url' ); ?>">
					<p class="description">Leave empty if don't want to redirect after form submit </p>
				</td>
			</tr>

			<?php do_action( 'form_general_settings_before_table_ends' ); ?>

		</tbody>
	</table>
	<?php


	}


	public static function create_form_translation_settings( $form_id ) {

?>


	<table class="styler-form-table form-table" >
		<tbody>
			<tr valign ="top">
				<th scope="row">Name Field</th>
				<td>

				<input type="text" class="normal-text " name="styler[translation][name]" value="<?php echo self::get( 'translation', 'name' ); ?>">

				</td>
			</tr>
			<tr valign ="top">
				<th scope="row">Email Field</th>
				<td>

				<input type="text" class="normal-text " name="styler[translation][email]" value="<?php echo self::get( 'translation', 'email' ); ?>">

				</td>
			</tr>
			<tr valign ="top">
				<th scope="row">Email validation error</th>
				<td>

				<input type="text" class="large-text " name="styler[translation][email_error]" value="<?php echo self::get( 'translation', 'email_error' ); ?>">

				</td>
			</tr>
			<tr valign ="top">
				<th scope="row">Already Subscribed Error</th>
				<td>

				<input type="text" class="large-text " name="styler[translation][already_subscribed]" value="<?php echo self::get( 'translation', 'already_subscribed' ); ?>">

				</td>
			</tr>

			<tr valign ="top">
				<th scope="row">reCAPTCHA label</th>
				<td>

				<input type="text" class="large-text " name="styler[translation][recaptcha_label]" value="<?php echo self::get( 'translation', 'recaptcha_label' ); ?>">

				</td>
			</tr>
			<tr valign ="top">
				<th scope="row">Optin Checkbox Text</th>
				<td>

				<input type="text" class="large-text " name="styler[translation][optin]" value="<?php echo self::get( 'translation', 'optin' ); ?>">

				</td>
			</tr>
			<tr valign ="top">
				<th scope="row">Subscriber Counter text</th>
				<td>

				<input type="text" class="large-text " name="styler[translation][subsciber_count]" value="<?php echo self::get( 'translation', 'subsciber_count' ); ?>">

				</td>
			</tr>

			<tr valign ="top">
				<th scope="row">Subscribe Button text</th>
				<td>

				<input type="text" class="normal-text " name="styler[translation][subscribe_button]" value="<?php echo self::get( 'translation', 'subscribe_button' ); ?>">

				</td>
			</tr>

				<tr valign ="top">
				<th scope="row">Subscribe Success Message</th>
				<td>

				<input type="text" class="large-text " name="styler[translation][subscribe_success_message]" value="<?php echo self::get( 'translation', 'subscribe_success_message' ); ?>">

				</td>
			</tr>
			<tr valign ="top">
				<th scope="row">Unsubscribe Button text</th>
				<td>

				<input type="text" class="normal-text " name="styler[translation][unsubscribe_button]" value="<?php echo self::get( 'translation', 'unsubscribe_button' ); ?>">

				</td>
			</tr>

				<tr valign ="top">
				<th scope="row">Unsubscribe Success Message</th>
				<td>

				<input type="text" class="large-text " name="styler[translation][unsubscribe_success_message]" value="<?php echo self::get( 'translation', 'unsubscribe_success_message' ); ?>">

				</td>
			</tr>

		</tbody>
	</table>


		<?php }



	public static function create_form_design_settings( $form_id ) {

?>


	<table class="styler-form-table form-table" >
		<tbody>

			<tr valign ="top">
				<th scope="row">Enable Custom styles for this form ?</th>
				<td>

				<input type="checkbox" class="checkbox " <?php  checked( self::get( 'form', 'enabled' ), '1' ); ?> name="styler[enabled]" value="1">
					<p class="description">Styles and layout will only apply if this checkbox is checked</p>
				</td>
			</tr>
			<tr valign ="top">
				<th scope="row">Width</th>
				<td>

				<input type="text" class="small-text " name="styler[width]" value="<?php echo self::get( 'form', 'width' ); ?>">
					<p class="description">Form width in px or percentage e.g 500px or 90% or auto </p>
				</td>
			</tr>
			<tr valign ="top">
				<th scope="row">Height</th>
				<td><input type="text" class="small-text" name="styler[height]" value="<?php echo self::get( 'form', 'height' ); ?>">
					<p class="description">Form height in px or percentage e.g 500px or 90% or auto </p>
				</td>
			</tr>

			<tr valign ="top">
				<th scope="row">Border</th>
				<td>
				<?php
		$border_width = self::get( 'form', 'border_width' );
		$border_style = self::get( 'form', 'border_style' );
?>
				<select name="styler[border_width]">
					<option <?php selected( $border_width, '0px' ) ?> value="1px">0px</option>
					<option <?php selected( $border_width, '1px' ) ?> value="1px">1px</option>
					<option <?php selected( $border_width, '2px' ) ?> value="2px">2px</option>
					<option <?php selected( $border_width, '3px' ) ?> value="3px">3px</option>
					<option <?php selected( $border_width, '4px' ) ?> value="4px">4px</option>
					<option <?php selected( $border_width, '5px' ) ?> value="5px">5px</option>
					<option <?php selected( $border_width, '6px' ) ?> value="6px">6px</option>
					<option <?php selected( $border_width, '7px' ) ?> value="7px">7px</option>
					<option <?php selected( $border_width, '8px' ) ?> value="8px">8px</option>
					<option <?php selected( $border_width, '9px' ) ?> value="9px">9px</option>
					<option <?php selected( $border_width, '10px' ) ?> value="10px">10px</option>
				</select>
				<select name="styler[border_style]">
					<option <?php selected( $border_style, 'solid' ) ?> value="solid">solid</option>
					<option <?php selected( $border_style, 'dotted' ) ?> value="dotted">dotted</option>
					<option <?php selected( $border_style, 'dashed' ) ?> value="dashed">dashed</option>
					<option <?php selected( $border_style, 'double' ) ?> value="double">double</option>
					<option <?php selected( $border_style, 'groove' ) ?> value="groove">groove</option>
					<option <?php selected( $border_style, 'ridge' ) ?> value="ridge">ridge</option>
					<option <?php selected( $border_style, 'inset' ) ?> value="inset">inset</option>
					<option <?php selected( $border_style, 'outset' ) ?> value="outset">outset</option>
				</select>
				<input type="text" name="styler[border_color]" value="<?php echo self::get( 'form', 'border_color' ); ?>" class="styler-color-picker" >

				</td>
			</tr>

			<tr valign ="top">
				<th scope="row">Background Color</th>
				<td><input type="text" class="regular-text styler-color-picker" name="styler[background_color]" value="<?php echo self::get( 'form', 'background_color' ); ?>">
					<p class="description">Form background color</p>
				</td>
			</tr>

			<tr valign ="top">
				<th scope="row">Padding</th>
				<td><div class="swp_styler_slider"></div><input type="text" class="small-text" name="styler[padding]" value="<?php echo self::get( 'form', 'padding' ); ?>">
				<?php //echo self::get_slider_labels(); ?>
				</td>
			</tr>

			<tr valign ="top">
				<th scope="row">Margin</th>
				<td><div class="swp_styler_slider"></div><input type="text" class="small-text" name="styler[margin]" value="<?php echo self::get( 'form', 'margin' ); ?>">
				</td>
			</tr>
			<?php do_action( 'form_design_settings_before_table_ends' ); ?>

		</tbody>
	</table>


 <?php }

	public static function create_field_design_settings( $form_id ) {

?>

			<table class=" styler-form-table form-table" >
		<tbody>
		<tr valign ="top">
				<th scope="row">Width</th>
				<td><input type="text" class="regular-text " name="styler[fields][width]" value="<?php echo self::get( 'fields', 'width' ); ?>">
					<p class="description">Input Width in px or percentage e.g 500px or 90% or auto </p>
				</td>
			</tr>
		<tr valign ="top">
				<th scope="row">Font Color</th>
				<td><input type="text" class="regular-text styler-color-picker" name="styler[fields][font_color]" value="<?php echo self::get( 'fields', 'font_color' ); ?>">
					<p class="description"></p>
				</td>
			</tr>

			<tr valign ="top">
				<th scope="row">Border</th>
				<td>
				<?php
		$border_width = self::get( 'fields', 'border_width' );
		$border_style = self::get( 'fields', 'border_style' );
?>
				<select name="styler[fields][border_width]">
					<option <?php selected( $border_width, '0px' ) ?> value="1px">0px</option>
					<option <?php selected( $border_width, '1px' ) ?> value="1px">1px</option>
					<option <?php selected( $border_width, '2px' ) ?> value="2px">2px</option>
					<option <?php selected( $border_width, '3px' ) ?> value="3px">3px</option>
					<option <?php selected( $border_width, '4px' ) ?> value="4px">4px</option>
					<option <?php selected( $border_width, '5px' ) ?> value="5px">5px</option>
					<option <?php selected( $border_width, '6px' ) ?> value="6px">6px</option>
					<option <?php selected( $border_width, '7px' ) ?> value="7px">7px</option>
					<option <?php selected( $border_width, '8px' ) ?> value="8px">8px</option>
					<option <?php selected( $border_width, '9px' ) ?> value="9px">9px</option>
					<option <?php selected( $border_width, '10px' ) ?> value="10px">10px</option>
				</select>
				<select name="styler[fields][border_style]">
					<option <?php selected( $border_style, 'solid' ) ?> value="solid">solid</option>
					<option <?php selected( $border_style, 'dotted' ) ?> value="dotted">dotted</option>
					<option <?php selected( $border_style, 'dashed' ) ?> value="dashed">dashed</option>
					<option <?php selected( $border_style, 'double' ) ?> value="double">double</option>
					<option <?php selected( $border_style, 'groove' ) ?> value="groove">groove</option>
					<option <?php selected( $border_style, 'ridge' ) ?> value="ridge">ridge</option>
					<option <?php selected( $border_style, 'inset' ) ?> value="inset">inset</option>
					<option <?php selected( $border_style, 'outset' ) ?> value="outset">outset</option>
				</select>
				<input type="text" name="styler[fields][border_color]" value="<?php echo self::get( 'fields', 'border_color' ); ?>" class="styler-color-picker" >

				</td>
			</tr>

			<tr valign ="top">
				<th scope="row">Background Color</th>
				<td><input type="text" class="regular-text styler-color-picker" name="styler[fields][background_color]" value="<?php echo self::get( 'fields', 'background_color' ); ?>">
					<p class="description">Field background color</p>
				</td>
			</tr>

			<tr valign ="top">
				<th scope="row">Padding</th>
				<td><div class="swp_styler_slider"></div><input type="text" class="small-text" name="styler[fields][padding]" value="<?php echo self::get( 'fields', 'padding' ); ?>">
				</td>
			</tr>

			<tr valign ="top">
				<th scope="row">Margin</th>
				<td><div class="swp_styler_slider"></div><input type="text" class="small-text" name="styler[fields][margin]" value="<?php echo self::get( 'fields', 'margin' ); ?>">
				</td>
			</tr>
	<?php do_action( 'field_design_settings_before_table_ends' ); ?>
		</tbody>
	</table>

  <?php  }

	public static function create_label_design_settings( $form_id ) {

?>

			<table class=" styler-form-table form-table" >
		<tbody>
			<tr valign ="top">
				<th scope="row">Min Width</th>
				<td><input type="text" class="regular-text" name="styler[label][min_width]" value="<?php echo self::get( 'label', 'min_width' ); ?>">
					<p class="description">Add minimum width for label in px or percentage e.g 100px or 20% or auto </p>
				</td>
			</tr>
		    <tr valign ="top">
				<th scope="row">Font Color</th>
				<td><input type="text" class="regular-text styler-color-picker" name="styler[label][font_color]" value="<?php echo self::get( 'label', 'font_color' ); ?>">
					<p class="description"></p>
				</td>
			</tr>

			<tr valign ="top">
				<th scope="row">Background Color</th>
				<td><input type="text" class="regular-text styler-color-picker" name="styler[label][background_color]" value="<?php echo self::get( 'label', 'background_color' ); ?>">
					<p class="description">Label background color</p>
				</td>
			</tr>


			<?php do_action( 'label_design_settings_before_table_ends' ); ?>
			</tbody>
	</table>

  <?php

	}

	public static function create_submit_design_settings( $form_id ) {

?>

			<table class=" styler-form-table form-table" >
		<tbody>
			<tr valign ="top">
				<th scope="row"> Width</th>
				<td><input type="text" class="regular-text" name="styler[submit][width]" value="<?php echo self::get( 'submit', 'width' ); ?>">
					<p class="description">Add  width for submit button in px or percentage e.g 100px or 20% or auto </p>
				</td>
			</tr>
		    <tr valign ="top">
				<th scope="row">Font Color</th>
				<td><input type="text" class="regular-text styler-color-picker" name="styler[submit][font_color]" value="<?php echo self::get( 'submit', 'font_color' ); ?>">
					<p class="description"></p>
				</td>
			</tr>

			<tr valign ="top">
				<th scope="row">Background Color</th>
				<td><input type="text" class="regular-text styler-color-picker" name="styler[submit][background_color]" value="<?php echo self::get( 'submit', 'background_color' ); ?>">
					<p class="description">Label background color</p>
				</td>
			</tr>
			<tr valign ="top">
				<th scope="row">Padding</th>
				<td><div class="swp_styler_slider"></div><input type="text" class="small-text" name="styler[submit][padding]" value="<?php echo self::get( 'submit', 'padding' ); ?>">
				</td>
			</tr>

			<tr valign ="top">
				<th scope="row">Margin</th>
				<td><div class="swp_styler_slider"></div><input type="text" class="small-text" name="styler[submit][margin]" value="<?php echo self::get( 'submit', 'margin' ); ?>">
				</td>
			</tr>
			<?php do_action( 'label_design_settings_before_table_ends' ); ?>
			</tbody>
	</table>

  <?php

	}

	public static function create_error_design_settings( $form_id ) {

?>

			<table class=" styler-form-table form-table" >
		<tbody>

		    <tr valign ="top">
				<th scope="row">Font Color</th>
				<td><input type="text" class="regular-text styler-color-picker" name="styler[error][font_color]" value="<?php echo self::get( 'error', 'font_color' ); ?>">
					<p class="description"></p>
				</td>
			</tr>
			<tr valign ="top">
				<th scope="row">Font Size</th>
				<td><input type="text" class="regular-text" name="styler[error][font_size]" value="<?php echo self::get( 'error', 'font_size' ); ?>">
					<p class="description">Add font size in px or percentage e.g 15px or 100%  </p>
				</td>
			</tr>

			<tr valign ="top">
				<th scope="row">Padding</th>
				<td><div class="swp_styler_slider"></div><input type="text" class="small-text" name="styler[error][padding]" value="<?php echo self::get( 'error', 'padding' ); ?>">
				</td>
			</tr>

			<tr valign ="top">
				<th scope="row">Margin</th>
				<td><div class="swp_styler_slider"></div><input type="text" class="small-text" name="styler[error][margin]" value="<?php echo self::get( 'error', 'margin' ); ?>">
				</td>
			</tr>
			<?php do_action( 'label_design_settings_before_table_ends' ); ?>
			</tbody>
	</table>

  <?php

	}

	public static function get( $type, $name  ) {
		$settings = self::$style_setting;
		$old_translation = self::$old_translation_settings;

		switch ( $type ) {
		case 'form':
			$val = !empty( $settings[$name] )?$settings[$name]:'';
			break;
		case 'label':
		case 'fields':
		case 'submit':
		case 'error':
			$val = !empty( $settings[$type][$name] )?$settings[$type][$name]:'';
			break;
		case 'translation':

			// New form, set default values;
			if ( ! isset( $settings[$type][$name] ) ) {
				switch ( $name ) {
				case 'name':
					$val = $old_translation['name'];
					break;
				case 'email':
					$val = $old_translation['email'];
					break;
				case 'email_error':
					$val =  $old_translation['email_error'];
					break;
				case 'already_subscribed':
					$val = $old_translation['already_subscribed'];
					break;
				case 'recaptcha_label':
					$val = $old_translation['recaptcha_label'];
					break;
				case 'optin':
					$val = $old_translation['terms_text'];
					break;
				case 'subsciber_count':
					$val = $old_translation['subscriber_counter'];
					break;
				case 'subscribe_button':
					$val = $old_translation['subscribe_button'];
					break;
				case 'subscribe_success_message':
					$val = $old_translation['success_message'];
					break;
				case 'unsubscribe_button':
					$val = 'Unsubscribe';
					break;
				case 'unsubscribe_success_message':
					$val = 'Thanks, you are now unsubscribed from list';
					break;

				}
			}else {
				$val = !empty( $settings[$type][$name] )?$settings[$type][$name]:'';
			}
			break;

		default:
			$val = !empty( $settings[$name] )?$settings[$name]:'';
			break;
		}

		return $val;
	}



}
