<?php
/*
	Plugin Name: Sendy Widget Pro
	Description: A Simple yet powerfull plugin to allow users to subscribe to your newsletter via Sendy
	Author: Webholics
	Author URI: https://webholics.org
	Plugin URI: https://webholics.org
	Version: 3.1
	Requires at least: 3.5
	Tested up to: 4.9
*/

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

define( "SENDY_WIDGET_PRO_DIR", WP_PLUGIN_DIR . "/" . basename( dirname( __FILE__ ) ) );
define( "SENDY_WIDGET_PRO_URL", plugins_url() . "/" . basename( dirname( __FILE__ ) ) );
define( "SENDY_WIDGET_PRO_VER", '3.1' );
// Backend Files

// regsiter post type
require_once SENDY_WIDGET_PRO_DIR.'/inc/admin/swp-posttype.php';
// add form builder settings
require_once SENDY_WIDGET_PRO_DIR.'/inc/admin/layout-builder/metaboxes.php';
// common functions
require_once SENDY_WIDGET_PRO_DIR.'/inc/functions.php';
// Settings
require_once SENDY_WIDGET_PRO_DIR.'/inc/admin/admin.php';
// Woo Product Metabox
require_once SENDY_WIDGET_PRO_DIR.'/inc/admin/class-sendy-woo-metabox.php';
// tab for custom filed
require_once SENDY_WIDGET_PRO_DIR.'/inc/admin/custom-field-tab.php';
// tab for translations
require_once SENDY_WIDGET_PRO_DIR.'/inc/admin/translation.php';
// map VC
require_once SENDY_WIDGET_PRO_DIR.'/inc/admin/vc-map.php';
// Save Layout settings
require_once SENDY_WIDGET_PRO_DIR.'/inc/admin/save.php';

require_once SENDY_WIDGET_PRO_DIR.'/inc/admin/layout-builder/class-swp-form-layout-settings.php';
add_action( 'plugins_loaded', array( 'SWP_Form_Layout_Settings', 'setup' ) );

require_once SENDY_WIDGET_PRO_DIR.'/inc/admin/layout-builder/class-swp-form-design-settings.php';
add_action( 'plugins_loaded', array( 'SWP_Form_Design_Settings', 'setup' ) );

//Frontend Files


// Sendy SHortcode
require_once SENDY_WIDGET_PRO_DIR.'/inc/display/shortcode-sendy-form.php';

add_action( 'plugins_loaded', array( 'Sendy_Shortcode', 'setup' ) );
// Widget
require_once SENDY_WIDGET_PRO_DIR.'/inc/display/widget.php';
// Deprecated Widget
require_once SENDY_WIDGET_PRO_DIR.'/inc/display/widget-deprecated.php';
// BuddyPress
require_once SENDY_WIDGET_PRO_DIR.'/inc/display/buddypress.php';
// Edd
require_once SENDY_WIDGET_PRO_DIR.'/inc/display/register.php';
// Shortcode Subscribe
require_once SENDY_WIDGET_PRO_DIR.'/inc/display/shortcode-subscribe.php';
// Shortcode UnSubscribe
require_once SENDY_WIDGET_PRO_DIR.'/inc/display/shortcode-unsubscribe.php';
// Woocommerce
require_once SENDY_WIDGET_PRO_DIR.'/inc/display/woocommerce.php';


add_filter( 'plugin_action_links', 'wpsendy_plugin_settings_link', 10, 2 );
function wpsendy_plugin_settings_link( $links, $file ) {

	if ( $file == 'sendy-widget-pro/sendy-widget.php' ) {
		/* Insert the link at the end*/
		$links['settings'] = sprintf( '<a href="%s"> %s </a>', admin_url( 'edit.php?post_type=swp_forms&page=sendy-widget-pro-settings' ), __( 'Settings', 'plugin_domain' ) );
	}

	return $links;
}



