<?php
class Sendy_Woo_Metabox {

	/**
	 * Constructor.
	 */
	public function __construct() {
		if ( is_admin() ) {
			add_action( 'add_meta_boxes', array( $this, 'add_metabox' ) );
			add_action( 'save_post', array( $this, 'save_metabox' ), 10, 2 );
		}

	}

	/**
	 * Adds the meta box.
	 */
	public function add_metabox() {
		add_meta_box(
			'sendy-woo-meta-box',
			__( '<h4>Select Sendy List</h4>', 'textdomain' ),
			array( $this, 'render_metabox' ),
			'product',
			'side',
			'low'
		);

	}

	/**
	 * Renders the meta box.
	 */
	public function render_metabox( $post ) {
		// Add nonce for security and authentication.
		wp_nonce_field( 'woo_sendy_nonce_action', 'woo_sendy_nonce' );

		// Use get_post_meta to retrieve an existing value from the database.
		$value = (array)get_post_meta( $post->ID, 'sendy_woo_product_list', true );
		$sendy_lists=get_option( 'sendy_lists' );
		//var_dump($value);
		// Display the form, using the current value.
		?>
		<label for="sendy_woo_product_list">
			<?php _e( 'List Ids', 'textdomain' ); ?>
		</label>
		<br/>
		<select name="sendy_woo_product_list[]" multiple>
			<?php
			foreach ($sendy_lists as $listid => $label ) {
				$selected = in_array( $listid, $value ) ? 'selected="selected"' : '';
				?>
				<option <?php echo $selected; ?> value="<?php echo esc_attr($listid); ?>"><?php esc_html_e($label); ?></option>
				<?php
			}
			?>
		</select>
	  	<p class="description">You can select multiple lists.</p>
		<?php

	}

	/**
	 * Handles saving the meta box.
	 *
	 * @param int     $post_id Post ID.
	 * @param WP_Post $post    Post object.
	 * @return null
	 */
	public function save_metabox( $post_id, $post ) {
		// Add nonce for security and authentication.
		$nonce_name   = isset( $_POST['woo_sendy_nonce'] ) ? $_POST['woo_sendy_nonce'] : ''; //phpcs:ignore
		$nonce_action = 'woo_sendy_nonce_action';

		// Check if nonce is set.
		if ( ! isset( $nonce_name ) ) {
			return;
		}

		// Check if nonce is valid.
		if ( ! wp_verify_nonce( $nonce_name, $nonce_action ) ) {
			return;
		}

		// Check if user has permissions to save data.
		if ( ! current_user_can( 'edit_post', $post_id ) ) {
			return;
		}

		// Check if not an autosave.
		if ( wp_is_post_autosave( $post_id ) ) {
			return;
		}

		// Check if not a revision.
		if ( wp_is_post_revision( $post_id ) ) {
			return;
		}

		if ( 'product' != $_POST['post_type'] ) { //phpcs:ignore
			return;
		}

		/* OK, it's safe for us to save the data now. */
		// Update the meta field.
		if ( isset( $_POST['sendy_woo_product_list'] ) ) {
			update_post_meta( $post_id, 'sendy_woo_product_list', wp_unslash( $_POST['sendy_woo_product_list'] ) );
		} else{
			update_post_meta( $post_id, 'sendy_woo_product_list', array() );
		}

	}

}

new Sendy_Woo_Metabox();
